/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.framebody;

import java.nio.ByteBuffer;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.datatype.NumberHashMap;
import org.jaudiotagger.tag.datatype.TCONString;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.framebody.AbstractFrameBodyTextInfo;
import org.jaudiotagger.tag.id3.framebody.ID3v23FrameBody;
import org.jaudiotagger.tag.id3.framebody.ID3v24FrameBody;
import org.jaudiotagger.tag.id3.valuepair.ID3V2ExtendedGenreTypes;
import org.jaudiotagger.tag.reference.GenreTypes;

public class FrameBodyTCON
extends AbstractFrameBodyTextInfo
implements ID3v24FrameBody,
ID3v23FrameBody {
    public FrameBodyTCON() {
    }

    public FrameBodyTCON(FrameBodyTCON body) {
        super(body);
    }

    public FrameBodyTCON(byte textEncoding, String text) {
        super(textEncoding, text);
    }

    public FrameBodyTCON(ByteBuffer byteBuffer, int frameSize) throws InvalidTagException {
        super(byteBuffer, frameSize);
    }

    @Override
    public String getIdentifier() {
        return "TCON";
    }

    public static String convertGenericToID3v24Genre(String value) {
        try {
            int genreId = Integer.parseInt(value);
            if (genreId < GenreTypes.getMaxGenreId()) {
                return String.valueOf(genreId);
            }
            return value;
        }
        catch (NumberFormatException nfe) {
            Integer genreId = GenreTypes.getInstanceOf().getIdForName(value);
            if (genreId != null) {
                return String.valueOf(genreId);
            }
            if (value.equalsIgnoreCase(ID3V2ExtendedGenreTypes.RX.getDescription())) {
                value = ID3V2ExtendedGenreTypes.RX.name();
            } else if (value.equalsIgnoreCase(ID3V2ExtendedGenreTypes.CR.getDescription())) {
                value = ID3V2ExtendedGenreTypes.CR.name();
            } else if (value.equalsIgnoreCase(ID3V2ExtendedGenreTypes.RX.name())) {
                value = ID3V2ExtendedGenreTypes.RX.name();
            } else if (value.equalsIgnoreCase(ID3V2ExtendedGenreTypes.CR.name())) {
                value = ID3V2ExtendedGenreTypes.CR.name();
            }
            return value;
        }
    }

    public static String convertGenericToID3v23Genre(String value) {
        try {
            int genreId = Integer.parseInt(value);
            if (genreId < GenreTypes.getMaxGenreId()) {
                return FrameBodyTCON.bracketWrap(String.valueOf(genreId));
            }
            return value;
        }
        catch (NumberFormatException nfe) {
            Integer genreId = GenreTypes.getInstanceOf().getIdForName(value);
            if (genreId != null) {
                return FrameBodyTCON.bracketWrap(String.valueOf(genreId));
            }
            if (value.equalsIgnoreCase(ID3V2ExtendedGenreTypes.RX.getDescription())) {
                value = FrameBodyTCON.bracketWrap(ID3V2ExtendedGenreTypes.RX.name());
            } else if (value.equalsIgnoreCase(ID3V2ExtendedGenreTypes.CR.getDescription())) {
                value = FrameBodyTCON.bracketWrap(ID3V2ExtendedGenreTypes.CR.name());
            } else if (value.equalsIgnoreCase(ID3V2ExtendedGenreTypes.RX.name())) {
                value = FrameBodyTCON.bracketWrap(ID3V2ExtendedGenreTypes.RX.name());
            } else if (value.equalsIgnoreCase(ID3V2ExtendedGenreTypes.CR.name())) {
                value = FrameBodyTCON.bracketWrap(ID3V2ExtendedGenreTypes.CR.name());
            }
            return value;
        }
    }

    public static String convertGenericToID3v22Genre(String value) {
        return FrameBodyTCON.convertGenericToID3v23Genre(value);
    }

    private static String bracketWrap(Object value) {
        return "(" + value + ')';
    }

    public static String convertID3v24GenreToGeneric(String value) {
        try {
            int genreId = Integer.parseInt(value);
            if (genreId < GenreTypes.getMaxStandardGenreId()) {
                return GenreTypes.getInstanceOf().getValueForId(genreId);
            }
            return value;
        }
        catch (NumberFormatException nfe) {
            if (value.equalsIgnoreCase(ID3V2ExtendedGenreTypes.RX.name())) {
                value = ID3V2ExtendedGenreTypes.RX.getDescription();
            } else if (value.equalsIgnoreCase(ID3V2ExtendedGenreTypes.CR.name())) {
                value = ID3V2ExtendedGenreTypes.CR.getDescription();
            } else {
                return value;
            }
            return value;
        }
    }

    private static String checkBracketed(String value) {
        value = value.replace("(", "");
        value = value.replace(")", "");
        try {
            int genreId = Integer.parseInt(value);
            if (genreId < GenreTypes.getMaxStandardGenreId()) {
                return GenreTypes.getInstanceOf().getValueForId(genreId);
            }
            return value;
        }
        catch (NumberFormatException nfe) {
            if (value.equalsIgnoreCase(ID3V2ExtendedGenreTypes.RX.name())) {
                value = ID3V2ExtendedGenreTypes.RX.getDescription();
            } else if (value.equalsIgnoreCase(ID3V2ExtendedGenreTypes.CR.name())) {
                value = ID3V2ExtendedGenreTypes.CR.getDescription();
            } else {
                return value;
            }
            return value;
        }
    }

    public static String convertID3v23GenreToGeneric(String value) {
        if (value.contains(")") && value.lastIndexOf(41) < value.length() - 1) {
            return FrameBodyTCON.checkBracketed(value.substring(0, value.lastIndexOf(41))) + ' ' + value.substring(value.lastIndexOf(41) + 1);
        }
        return FrameBodyTCON.checkBracketed(value);
    }

    public static String convertID3v22GenreToGeneric(String value) {
        return FrameBodyTCON.convertID3v23GenreToGeneric(value);
    }

    public void setV23Format() {
        TCONString text = (TCONString)this.getObject("Text");
        text.setNullSeperateMultipleValues(false);
    }

    @Override
    protected void setupObjectList() {
        this.objectList.add(new NumberHashMap("TextEncoding", (AbstractTagFrameBody)this, 1));
        this.objectList.add(new TCONString("Text", this));
    }
}

